/******************************************************************************/
#include "stdafx.h"
/******************************************************************************/
Mesh mesh;
/******************************************************************************/
void InitPre()
{
   App.name="Rendering";
   App.flag=APP_MS_EXCLUSIVE;
   PakAdd("../data/engine.pak");
}
/******************************************************************************/
Bool Init()
{
   Cam.dist=2;

   mesh.create(1).B(0).create(Ball(1),VTX_TX0|VTX_NRM|VTX_TNG);                   // create Mesh with 1 Mshb, and create this Mshb from Ball with automatic texture coordinates, normals and tangents
   mesh.setMaterial(Materials("../data/mtrl/brick/0.mtrl")).setRender().setBox(); // set mesh material, rendering version and bounding box

   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;
   CamHandle(1.5,10,CAMH_ZOOM|CAMH_ROT);
   return true;
}
/******************************************************************************/
void Render() // Rendering Method
{
   switch(Renderer()) // Rendering Method will be called multiple times with different Rendering Modes
   {
      // first there is "solid rendering" mode where you need to render all solid meshes
      case RM_SOLID:
         mesh.draw();
      break;

      // then there is "light rendering" mode where you need to render all the lights
      case RM_LIGHT: 
         LightDir(1,Vec(0,0,1)).add();
      break;
   }
}
void Draw()
{
   // instead of typical "D.clear(WHITE);" we'll now use advanced rendering :
   Renderer(Render); // render with 'Render' method

   D.text(0,0.9,S+"Fps: "+Tm.fps); // show number of fps
}
/******************************************************************************/
